<?php

namespace backend\controllers;

use Yii;
use common\models\Packedtasks;
use common\models\Packetcommands;
use backend\models\PackedtasksSearch;
use common\models\Bots;
use common\models\Files;
use backend\models\Admin;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use \yii\web\Response;
use yii\helpers\Html;
use yii\helpers\Url;
/**
 * PackedtasksController implements the CRUD actions for Packedtasks model.
 */
class PackedtasksController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                    'bulk-delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Packedtasks models.
     * @return mixed
     */
    public function actionIndex()
    {    
        $searchModel = new PackedtasksSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }


    /**
     * Displays a single Packedtasks model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {   
        $request = Yii::$app->request;
        if($request->isAjax){
            Yii::$app->response->format = Response::FORMAT_JSON;
            return [
                    'title'=> "Packedtasks #".$id,
                    'content'=>$this->renderAjax('view', [
                        'model' => $this->findModel($id),
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                            Html::a('Edit',['update','id'=>$id],['class'=>'btn btn-primary','role'=>'modal-remote'])
                ];    
        }else{
            return $this->render('view', [
                'model' => $this->findModel($id),
            ]);
        }
    }

    /**
     * Creates a new Packedtasks model.
     * For ajax request will return json object
     * and for non-ajax request if creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $request = Yii::$app->request;
        $model = new Packedtasks();  

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            if($request->isGet){
                return [
                    'title'=> "Create new Packedtasks",
                    'content'=>$this->renderAjax('create', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                                Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])
        
                ];         
            }else if($model->load($request->post())){
                $model->groups = ($model->groups) ? json_encode($model->groups) : '[]';
                if($model->save()){
                    return [
                        'forceReload'=>'#crud-datatable-pjax',
                        'title'=> '',
                        'content' => '<b>'.$model->name."</b> Successfully created!",
                        'footer'=> Html::button(' Ok ',['class'=>'btn btn-primary pull-right btn-bright','data-dismiss'=>"modal"])
                    ]; 
                }         
                        
            }else{           
                return [
                    'title'=> "Create new Packedtasks",
                    'content'=>$this->renderAjax('create', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                                Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])
        
                ];         
            }
        }else{
            /*
            *   Process for non-ajax request
            */
            if ($model->load($request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('create', [
                    'model' => $model,
                ]);
            }
        }
       
    }

    /**
     * Updates an existing Packedtasks model.
     * For ajax request will return json object
     * and for non-ajax request if update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $request = Yii::$app->request;
        $model = $this->findModel($id);       

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            if($request->isGet){
                return [
                    'title'=> "Update Packedtasks #".$id,
                    'content'=>$this->renderAjax('update', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                                Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])
                ];         
            }else if($model->load($request->post())){
                $model->groups = ($model->groups) ? json_encode($model->groups) : '[]';
                if($model->save()){
                    return [
                        'forceReload'=>'#crud-datatable-pjax',
                        'title'=> '',
                        'content' => '<b>'.$model->name."</b> Successfully created!",
                        'footer'=> Html::button(' Ok ',['class'=>'btn btn-primary pull-right btn-bright','data-dismiss'=>"modal"])
                    ]; 
                }
                    
            }else{
                 return [
                    'title'=> "Update Packedtasks #".$model->name,
                    'content'=>$this->renderAjax('update', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                                Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])
                ];        
            }
        }else{
            /*
            *   Process for non-ajax request
            */
            if ($model->load($request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('update', [
                    'model' => $model,
                ]);
            }
        }
    }

    /**
     * Delete an existing Packedtasks model.
     * For ajax request will return json object
     * and for non-ajax request if deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $request = Yii::$app->request;
        $this->findModel($id)->delete();

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ['forceClose'=>true,'forceReload'=>'#crud-datatable-pjax'];
        }else{
            /*
            *   Process for non-ajax request
            */
            return $this->redirect(['index']);
        }


    }

     /**
     * Delete multiple existing Packedtasks model.
     * For ajax request will return json object
     * and for non-ajax request if deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionBulkDelete()
    {        
        $request = Yii::$app->request;
        $pks = explode(',', $request->post( 'pks' )); // Array or selected records primary keys
        foreach ( $pks as $pk ) {
            $model = $this->findModel($pk);
            $model->delete();
        }

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ['forceClose'=>true,'forceReload'=>'#crud-datatable-pjax'];
        }else{
            /*
            *   Process for non-ajax request
            */
            return $this->redirect(['index']);
        }
       
    }

    /**
     * Finds the Packedtasks model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Packedtasks the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Packedtasks::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    public function actionPackettools($id)
    {
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $accessFilter = json_decode(Yii::$app->user->identity->groups);

        $request = Yii::$app->request;
        $model = $this->findModel($id);
        

        if(Yii::$app->user->identity->role != Admin::ROLE_SUPER_ADMIN){
            if(!in_array($model->groups,$accessFilter)){
                return $this->goHome();
            }
        }

        $relatedModel = New Packetcommands();
                
        if($request->isGet){ // render
            //$id = Bots::find()->where(['like', 'bot', $id])->one()['id']; // id as botid
            return $this->render('packettools', [
                'model' => $model,
                'relatedModel' => $relatedModel,
            ]);
        }elseif($request->isPost){
            if ($model->load($request->post())) {
                if(!$this->packetCommandValidate($model)){
                    
                    Yii::$app->session->setFlash('error', "Illegal command format!");
                    return $this->redirect(Yii::$app->request->url);
                }

                $relatedModel->step = $model->field20;
                $relatedModel->packetcommandtype = $model->field21;
                $relatedModel->varname = $model->field22;
                $relatedModel->varvalue = $model->field23;
                $relatedModel->arg1 = $model->field24;
                $relatedModel->condition = $model->field25;
                if(!($model->field25 == 'isnull' || $model->field25 == 'isnotnull')){
                    $relatedModel->arg2 = $model->field26;
                }
                $relatedModel->action = $model->field27;
                $relatedModel->task_id = $model->id;
                
                // run bot command
                if($model->field21 == 'runbot'){
                    if(Bots::botCommandValidate($model)){
                        //print_r($model->field0);die();
                        if(isset($model->field0)){

                            // parse command
                            //$commandParsed = explode(':',$model->lastcommand);
                            $commandParsed[0] = $model->field0; // allways

                            $commandParsed[1] = $model->field1;
                            $commandParsed[2] = $model->field2;
                            $commandParsed[3] = $model->field3;
                            $commandParsed[4] = $model->field4;
                            $commandParsed[5] = $model->field5;
                            if($commandParsed[0]!='runcode'){ // not for run code
                                if($model->field6!=''){
                                    $commandParsed[6] = '\r\n'.$model->field6; // divider before script
                                }
                            }else{
                                $commandParsed[6] = $model->field6;
                            }
                            $commandParsed[7] = ($model->field0=="runexe" || $model->field0=="rundll" || $model->field0=="updatenow") ? "" : $model->field7;
                            //$commandParsed[7] = $model->field7;
                            
                            foreach ($commandParsed as $key => $value){ 
                                if ($value === ""){ 
                                    unset($commandParsed[$key]);
                                    $commandParsed[] = $value;
                                }
                            }

                            // rebuild array index
                            $commandParsed = array_values($commandParsed);
                            //print_r($commandParsed);die();

                            // 4-th param passed, but set as empty
                            // 7-th param script body replace \t on __
                            $usercommand = $model->field0.chr(9).$model->field1.chr(9).$model->field2.chr(9).$model->field3.chr(9).chr(9).$model->field5.chr(9).$model->field6.chr(9).str_replace(chr(9), '  ', $model->field7);
                           
                            $upd = ($commandParsed[0]=='updatenow') ? 1 : 0; // 10 update flag

                            $commandParsed[0] = Bots::CommandsList($commandParsed[0]);

                            //print_r($upd);die();
                            switch ($commandParsed[0]) {
                                case '0':
                                    //$commandParsed[1] = $commandParsed[1];
                                    //$model->busy = 0; // busy not set for command nop
                                    //$model->save(false);
                                    break;
                                case '1':
                                    # code...
                                    break;
                                case '10':
                                
                                    $commandParsed[1] = Bots::RuntypeList($commandParsed[1]);
                                   
                                    if($commandParsed[1]!='4'){
                                        $commandParsed[3] = Bots::MaskList($commandParsed[3]);
                                    }
                                    
                                    
                                    break;
                                case '11':
                                    //$commandParsed[1] = Bots::RuntypeList($commandParsed[1]);
                                    break;
                                case '12':
                                    $commandParsed[1] = Bots::RuntypeList($commandParsed[1]);
                                    $commandParsed[3] = str_replace(chr(13).chr(10), '\r\n', $commandParsed[3]);
                                    //$commandParsed[4] = '\r\n'.$commandParsed[4]; // may changed?
                                    break;
                                case '13':
                                    $commandParsed[1] = Bots::RuntypeList($commandParsed[1]);
                                    $commandParsed[3] = str_replace(chr(13).chr(10), '\r\n', $commandParsed[3]);
                                    //$commandParsed[4] = '\r\n'.$commandParsed[4];
                                    break;
                                case '14':
                                    Commands::updateAll(['status' => 2], ['and', ['bot_id' => $model->id], ['<=','status', 1]]);
                                    break;
                                case '15':
                                    # code...
                                    break;
                                case '16':
                                    # code...
                                    break;
                                case '17':
                                    $model->field6 = trim(str_replace(' ','',str_replace('0x', '', $model->field6)));
                                    $model->field6 = str_replace(chr(13), '', $model->field6);
                                    $model->field6 = str_replace(chr(10), '', $model->field6);
                    
                                    break;
                                
                                default:
                                    # code...
                                    break;
                            }
                            // end recoding
        // TODO if emty file - error 2   
        //print_r($commandParsed);die();                 
                            if($commandParsed[0]==10 || $commandParsed[0]==11){

                                if(!($commandParsed[2] == 'nofile' || $commandParsed[4] == 'nofile')){
                                    // prepare file for download if not force update

                                    // make replace link
                                    //$filedest = $model->bot.'/'.Yii::$app->security->generateRandomString(40);
                                    
                                    // get command link and replace
                                    if($commandParsed[0]==10){
                                        $c = 4; // 0-3 subcommand
                                        if($commandParsed[1]=='4'){
                                            $c = 2; // 4 subcommand
                                        }
                                    }else{
                                        $c = 2; // 11 command
                                    }

                                    // set  bot group to file
                                    //$f = Files::findOne(['storedfilename' => $commandParsed[$c]]);
                                    //$f->group = $model->group;
                                    //$f->save(false);

                                    $filepath = Yii::getAlias('@absPath').$commandParsed[$c];
                                    $sourcepath = $commandParsed[$c];

                                    //$commandParsed[$c] = str_replace(Yii::$app->params['backend'],'',Url::base(true)).'/'.$filedest;

                                    //$commandParsed[$c] = Url::base(true).'/'.$filedest;

                                    //$commandParsed[$c] = '/'.$filedest; // test

                                    // make bot path into web area
                                    //FileHelper::createDirectory(Yii::getAlias('@absPath').'/api/web/'.$model->bot);

                                    // make shell for crypt and copy to web area
                                    //$shellcommand = 'cd '.Yii::getAlias('@absPath').'/utilities; ./xor '.$model->bot.' '.$filepath.' '.'../api/web/'.$filedest; // TODO new generator need

                                    // fix clone
                                    //$clone = New Clones();
                                    //$clone->source = $sourcepath;
                                    //$clone->clone = '/'.$filedest;
                                    //$clone->clonetype = 0; // file for command 10
                                    //$clone->save(false);
                                    
                                    //$e = shell_exec($shellcommand);
                                }else{
                                    $commandParsed[2] = '';
                                }
                            }
                            //print_r($commandParsed);die();
                            $newcommand = '';
                            foreach ($commandParsed as $key => $value) {
                                $newcommand .= $value.' ';
                            }

                            $relatedModel->command = trim($newcommand);
                            $relatedModel->usercommand = trim($usercommand);
                            //$relatedModel->created_at = new Expression('NOW()');
                            //$relatedModel->admin = Yii::$app->user->id;
                            $relatedModel->commandtype = $commandParsed[0];
                            ///$relatedModel->bot_id = $model->id;
                            //$relatedModel->ip = $model->ip;
                            //$relatedModel->group = $model->group;
                            $relatedModel->save(false);

                            
                        }
                    }
                }
                $relatedModel->save(false);
                return $this->redirect(Yii::$app->request->url);
                
            }
        }else{
            return $this->redirect(['index']);
        }
    }

    public function packetCommandValidate($model){

        return true;
    }
}
